<?php

class WPBakeryShortCode_Tt_Blog_Posts extends WPBakeryShortCode {
    protected function content( $atts, $content = null){
        extract(shortcode_atts(array(
            'count' => '',
            'categories' => '',
            'extra_class' => ''
        ), $atts));

        $cats = array();
        if( !empty($categories) ){
            $exps = explode(",", $categories);
            foreach($exps as $val){
                if( (int)$val>-1 ){
                    $cats[]=(int)$val;
                }
            }
        }

        $args = array(
                        'post_type' => 'post',
                        'posts_per_page' => $count,
                        'ignore_sticky_posts' => true
                    );
        if(!empty($cats)){
            $args['category__in'] = $cats;
        }

        $items = '';
        $posts_query = new WP_Query($args);
        while ( $posts_query->have_posts() ) {
            $posts_query->the_post();
            $excerpt = wp_trim_words( wp_strip_all_tags(do_shortcode(get_the_content())), 30 );
            $img = '';
            if( has_post_thumbnail() ){
                $img = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'blog-thumb' );
                $img = !empty($img) ? $img[0] : '';
            }

            $postclass = implode(' ',get_post_class());
            $items .= "<div class='blog-item item'>
                    <a href='".get_permalink()."'>".get_the_post_thumbnail( get_the_ID(), 'blog-thumb' )."</a> 
                      <h4><a href='".get_permalink()."'>".get_the_title()."</a></h4>
                      <p>$excerpt</p>
                        <div class='button-style-2'>
                             <a href='".get_permalink()."' class='b-sm butt-style'>".__('Read More','themeton')."</a>
                        </div>
                </div>
";
}

        // reset query
        wp_reset_postdata();
        
        return "<div class='izotope-container gutt-col3'>
                    <div class='grid-sizer'></div>
                    $items
                </div>";
    }
}

vc_map( array(
    "name" => __( 'Blog Posts', 'themeton' ),
    "description" => __("Only post type: post", 'themeton'),
    "base" => 'tt_blog_posts',
    "icon" => "icon-wpb-themeton",
    "content_element" => true,
    "category" => __('Themeton', 'themeton'),
    'params' => array(
        array(
            "type" => 'textfield',
            "param_name" => "count",
            "heading" => __("Posts Count", 'themeton'),
            "value" => '3'
        ),
        array(
            "type" => 'textfield',
            "param_name" => "categories",
            "heading" => __("Categories", 'themeton'),
            "description" => __("Specify category Id or leave blank to display items from all categories.", 'themeton'),
            "value" => ''
        ),
        array(
            "type" => "textfield",
            "param_name" => "extra_class",
            "heading" => __("Extra Class", 'vc_extend'),
            "value" => "",
            "description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'vc_extend'),
        )
    )
));