<?php

class WPBakeryShortCode_Team extends WPBakeryShortCode {
    protected function content( $atts, $content = null){
        extract( shortcode_atts( array(
            "name" => 'Name',
            "about" => 'About',
            "position" => 'description',
            "image" => '',
            "number"     => "",
            "social_facebook" => "",
            "social_twitter" => "",
            "social_linkedin" => "",
            "social_instagram" => "",
            "extra_class" => ""
        ), $atts ) );

        $image = wp_get_attachment_image($image, 'team-member');

        $socials = '';
        $socials .= $social_facebook == '' ? '' : '<a href="'.$social_facebook.'"><i class="fa fa-facebook"></i></a>';
        $socials .= $social_twitter == '' ? '' : '<a href="'.$social_facebook.'"><i class="fa fa-twitter"></i></a>';
        $socials .= $social_linkedin == '' ? '' : '<a href="'.$social_linkedin.'"><i class="fa fa-linkedin"></i></a>';
        $socials .= $social_instagram == '' ? '' : '<a href="'.$social_instagram.'"><i class="fa fa-instagram"></i></a>';

        $result = '<div class="team-block">
                        '.$image.'
                          <div class="later-team" style="left: 100%;">
                             <h4>'.$name.'</h4>
                               <h6>'.$position.'</h6>
                                 <div class="hiden-text">
                                   <p>'.$about.'</p>   
                                     <div class="team-share">
                                        '.$socials.'
                                     </div>
                                  </div>
                          </div>
                    </div>';

        return $result;
    }
}

vc_map( array(
            "name" => __("Team member", 'themeton'),
            "description" => __("", 'themeton'),
            "base" => "team",
            "class" => "",
            "icon" => "icon-wpb-quickload",
            "category" => __('Themeton', 'themeton'),
            "show_settings_on_create" => true,
            "params" => array(
                array(
                    'type' => 'textfield',
                    "param_name" => "name",
                    "heading" => __("Name", 'themeton'),
                    "value" => 'Tom Smith',
                    "holder" => 'div'
                ),
                array(
                    'type' => 'textfield',
                    "param_name" => "position",
                    "heading" => __("Position", 'themeton'),
                    "value" => 'CEO - Webdesign'
                ),
                array(
                    'type' => 'textarea',
                    "param_name" => "about",
                    "heading" => __("About", 'themeton'),
                    "value" => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit. Ducimus accusantium, temporibus distinctio commodi harum'
                ),
                array(
                    'type' => 'attach_image',
                    "param_name" => "image",
                    "heading" => __("Image Image", 'themeton'),
                    "value" => ''
                ),
                array(
                    'type' => 'textfield',
                    "param_name" => "social_facebook",
                    "heading" => __("Facebook", 'themeton'),
                    "value" => ''
                ),
                array(
                    'type' => 'textfield',
                    "param_name" => "social_twitter",
                    "heading" => __("Twitter", 'themeton'),
                    "value" => ''
                ),
                array(
                    'type' => 'textfield',
                    "param_name" => "social_linkedin",
                    "heading" => __("Linkedin", 'themeton'),
                    "value" => ''
                ),
                array(
                    'type' => 'textfield',
                    "param_name" => "social_instagram",
                    "heading" => __("Instagram", 'themeton'),
                    "value" => ''
                ),
                array(
                    "type" => "textfield",
                    "param_name" => "extra_class",
                    "heading" => __("Extra Class", 'vc_extend'),
                    "value" => "",
                    "description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'vc_extend'),
                )
            )
        ) );
